/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoSort;
import com.quantumdata.ftp.FtpFile;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;

public class JCoDirComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private Icon m_hardDriveIcon = null;
    private Icon m_directoryIcon = null;
    private Vector m_roots = null;
    private CoFile[] m_dirs = new CoFile[0];
    private CoFile m_dir = null;
    private CoFile m_sel = null;
    private boolean m_isGenerator = false;
    private ActionListener m_listener = null;
    private static final int SPACE = 10;

    private void installIcons() {
        if (this.m_hardDriveIcon == null) {
            this.m_hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        }
        if (this.m_directoryIcon == null) {
            this.m_directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        }
    }

    public JCoDirComboBox(boolean bl) {
        this.m_isGenerator = bl;
        this.setModel(new DirModel());
        this.setRenderer(new DirRenderer());
    }

    public void setDirActionListener(ActionListener actionListener) {
        this.m_listener = actionListener;
    }

    public CoFile getDir() {
        return this.m_dir;
    }

    public void addRoot(CoFile coFile) {
        if (this.m_roots == null) {
            this.m_roots = new Vector();
        }
        this.m_roots.addElement(coFile);
    }

    public void setDir(CoFile coFile) {
        this.m_dir = coFile;
        this.m_sel = coFile;
        if (this.m_dir != null) {
            int n;
            int n2;
            CoFile[] coFileArray;
            if (this.m_roots == null) {
                this.m_roots = new Vector();
                coFileArray = this.m_dir.listCoRoots();
                for (n2 = 0; n2 < coFileArray.length; ++n2) {
                    this.m_roots.addElement(coFileArray[n2]);
                }
            }
            coFileArray = new Vector();
            coFileArray.addAll(this.m_roots);
            if (this.m_isGenerator && this.m_roots.size() == 1) {
                FtpFile ftpFile;
                FtpFile ftpFile2 = (FtpFile)this.m_roots.get(0);
                n = this.m_dir.getPathDepth();
                String string = n < 1 ? "" : this.m_dir.getPathFragment(1).getName();
                if (!string.equals("ram20K")) {
                    ftpFile = new FtpFile("/ram20K", ftpFile2.getClient());
                    ftpFile.setDescription("ScratchPad");
                    coFileArray.addElement(ftpFile);
                }
                if (!string.equals("card0")) {
                    ftpFile = new FtpFile("/card0", ftpFile2.getClient());
                    ftpFile.setDescription("PCCard");
                    coFileArray.addElement(ftpFile);
                }
                if (!string.equals("tffs0")) {
                    ftpFile = new FtpFile("/tffs0", ftpFile2.getClient());
                    ftpFile.setDescription("FlashMem");
                    coFileArray.addElement(ftpFile);
                } else {
                    this.m_dir.setDescription("FlashMem");
                }
            }
            n2 = this.m_dir.getPathDepth();
            for (n = 1; n < n2; ++n) {
                coFileArray.addElement(this.m_dir.getPathFragment(n));
            }
            if (n2 >= 1) {
                coFileArray.addElement(this.m_dir);
            }
            this.m_dirs = coFileArray.toArray(new CoFile[coFileArray.size()]);
            this.m_dirs = CoSort.listOrder(this.m_dirs, 5);
        } else {
            this.m_dirs = new CoFile[0];
        }
        ((DirModel)this.getModel()).update();
        this.setEnabled(this.m_dirs.length > 0);
    }

    public CoFile getSelectedDir() {
        return this.m_sel;
    }

    private class DirModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 1L;

        private DirModel() {
        }

        public void update() {
            this.fireContentsChanged(this, 0, JCoDirComboBox.this.m_dirs.length - 1);
        }

        public int getSize() {
            return JCoDirComboBox.this.m_dirs.length;
        }

        public Object getElementAt(int n) {
            return JCoDirComboBox.this.m_dirs[n];
        }

        public void setSelectedItem(Object object) {
            JCoDirComboBox.this.m_sel = (CoFile)object;
            if (JCoDirComboBox.this.m_listener != null) {
                JCoDirComboBox.this.m_listener.actionPerformed(new ActionEvent(this, 1001, ((Object)JCoDirComboBox.this.m_sel).toString()));
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return JCoDirComboBox.this.m_sel;
        }
    }

    private class IndentIcon
    implements Icon {
        private Icon m_icon = null;
        private int m_depth = 0;

        private IndentIcon() {
        }

        public void setDepth(int n) {
            this.m_depth = n;
        }

        public int getDepth() {
            return this.m_depth;
        }

        public void setIcon(Icon icon) {
            this.m_icon = icon;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.m_icon != null) {
                this.m_icon.paintIcon(component, graphics, n + this.m_depth * 10, n2);
            }
        }

        public int getIconWidth() {
            return this.m_depth * 10 + (this.m_icon != null ? this.m_icon.getIconWidth() : 0);
        }

        public int getIconHeight() {
            return this.m_icon != null ? this.m_icon.getIconHeight() : 1;
        }
    }

    private class DirRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        IndentIcon m_indent;

        private DirRenderer() {
            this.m_indent = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof CoFile) {
                CoFile coFile = (CoFile)object;
                this.m_indent.setDepth(coFile.getPathDepth());
                JCoDirComboBox.this.installIcons();
                this.m_indent.setIcon(JCoDirComboBox.this.m_directoryIcon);
                switch (this.m_indent.getDepth()) {
                    case 0: 
                    case 1: {
                        this.m_indent.setIcon(JCoDirComboBox.this.m_hardDriveIcon);
                        break;
                    }
                    case 2: {
                        if (!JCoDirComboBox.this.m_isGenerator) break;
                        this.m_indent.setIcon(JCoDirComboBox.this.m_hardDriveIcon);
                    }
                }
                this.setIcon(this.m_indent);
                if (this.m_indent.getDepth() > 0) {
                    String string = coFile.getName();
                    if (!coFile.getDescription().equals("")) {
                        string = string + "   (" + coFile.getDescription() + ")";
                    }
                    this.setText(string);
                } else {
                    this.setText(coFile.getHost() + ((Object)coFile).toString());
                }
            }
            return this;
        }
    }
}

